/* this program converts 24 bit TGA picture files to 16 bit CRY or RGB format */
/* the TGA file has an 18 byte header, sometimes followed by the filename */
/* followed by the RGB data */
/* the header contains the following data: */
/* 00		how many characters in the filename at the end of the header */
/* 01-12	???					*/
/* 13-14	image width			*/
/* 15-16	image height			*/
/* 17		24 if 24 bit data	*/
/* 18		???				*/
/* the RGB data is one byte for red, one byte for green, one byte for blue */
/* the BOTTOM LINE OF THE IMAGE DATA IS FIRST, IN THE ORDER BGRBGR etc */
/* but each line has the pixels in left to right order */

#include "tga.h"						/* resource file definitions */
#include <obdefs.h>
#include <osbind.h>
#include <gemdefs.h>
#include <aesbind.h>
#include <vdibind.h>
#include <stdio.h>
#include <stat.h>
#include <errno.h>

#define ARROW_MOUSE	graf_mouse(ARROW, &dummy)		/* change mouse to arrow */
#define BEE_MOUSE	graf_mouse(BUSY_BEE, &dummy)	/* change mouse to bee */
#define HIDE_MOUSE	graf_mouse(M_OFF, &dummy)
#define SHOW_MOUSE	graf_mouse(M_ON, &dummy)
#define DESKSIZE	xdesk,ydesk,wdesk,hdesk

#define F1_KEY		0x3B00
#define F10_KEY	0x4400

#define NO		0
#define YES		1

#define CRY16		0
#define RGB16		1
#define RGB24		2

int contrl[12], ptsin[256], ptsout[256], intin[256], intout[256];
int work_in[256], work_out[256];

int quit;						/* program ends when quit = 0 */
int button;					/* file selector button */
int dummy;					/* used in mouse change statements */
int handle;					/* vdi handle */
int xdesk,ydesk,wdesk,hdesk;		/* coordinates of usable part of screen */
int xdial,ydial,wdial,hdial;		/* coordinates of dialog box */
int pxdial,pydial;
int pwdial,phdial;				/* coordinates of percent dialog box */
long menuaddr;					/* address of menus */
int event_type;				/* evnt_multi event */
int mousex,mousey;				/* mouse position when event occurs */
int key;						/* key pressed when event occurs */
int mgbuf[8];					/* message buffer for evnt_multi */

char dirpath[120];				/* pathname with filename appended */
char pathname[120];				/* the complete path with filename */
char dirset[120];				/* used in the pathname construction */
int drive;					/* used in the pathname construction */
char drv[2];					/* used in the pathname construction */
char savepath[120];				/* new pathname with filename appended */
char savepathname[120];			/* pathname for new file */
int i;						/* temporary counter variable */
char name[13];					/* filename in file selector */
char ts[200];					/* temp string used for printing stuff in file */

char picname[13];				/* name of image to be printed in file */
long filesize[99];				/* length of entire files (99 max) */
char filename[99][13];			/* filenames (99 max) */
int filecount;					/* number of files to convert */
int filenum;					/* current file number */
int fhandle;					/* file pointer */
int nhandle;					/* new file pointer */
char *srcfile;					/* buffer holding loaded file */
char *newdata;					/* address of beginning of TGA data */

OBJECT *daddr;					/* address of dialog box */
OBJECT *paddr;					/* address of percent dialog box */
int exitobj;					/* button that exits dialog box */

unsigned int image_w;			/* width of image in pixels from TGA header */
unsigned int image_h;			/* height of image in pixels from TGA header */
unsigned int bits_per_pixel;		/* bits per pixel from TGA file header */
unsigned int bytes_in_name;		/* bytes in filename at end of TGA header */
int line;						/* counts lines in image during conversion */
unsigned int column;			/* counts columns in image during conversion */
int	items_per_line;			/* count words per line in new file */

int hflip_flag;				/* if image should be flipped horizontally */
int vflip_flag;				/* if image should be flipped vertically */
int data_type;					/* if new data should be CRY or RGB format */

long completed;				/* % of lines converted lines from TGA file */

unsigned int color_offset;		/* offset for cry lookup table */
unsigned char intensity;
unsigned char red,green,blue;		/* RGB colors for each pixel */
extern unsigned char cry[];		/* cry lookup table */

char filenotfound[] =	"[1][File not found.][  OK  ]";
char outofmemory[] =	"[1][Not enough memory.][  OK  ]";
char wrongformat[] =	"[1][Wrong file format.][  OK  ]";

main()
{
	appl_init();							/* initialize application */
	handle = graf_handle(&dummy, &dummy, &dummy, &dummy);
	for (i = 1; i < 10; ++i)
		work_in[i] = 1;
	work_in[0] = Getrez() + 2;
	work_in[10] = 2;
	v_opnvwk(work_in, &handle, work_out);
	rsrc_load("TGA.RSC");
	rsrc_gaddr(0,MENUS,&menuaddr);				/* get address of menu bar */
	data_type = CRY16;							/* default is to write CRY data */
	menu_icheck(menuaddr,CRYDATA,YES);
	menu_icheck(menuaddr,RGBDATA,NO);
	menu_icheck(menuaddr,RGB24DAT,NO);
	hflip_flag = NO;							/* default option is no hflip */
	vflip_flag = NO;							/* default option is no vflip */
	menu_icheck(menuaddr,HORFLIP,hflip_flag);
	menu_icheck(menuaddr,VERTFLIP,vflip_flag);
	menu_bar(menuaddr,YES);						/* show the menu bar */
	rsrc_gaddr(R_TREE, PERCENT, &paddr);			/* get address of percent box */
	getpath();									/* get default path */
	ARROW_MOUSE;

	quit = NO;
	while(quit == NO)
	{
		event_type = evnt_multi((MU_MESAG|MU_KEYBD),
					1,1,1,				/* evnt_button       */
					0,0,0,0,0,			/* mouse enters rect */
					1,0,0,0,0,			/* mouse exits rect  */
					mgbuf,				/* evnt_mesg         */
					0,0,					/* evnt_timer        */
					&mousex,&mousey,		/* mouse x,y pos     */
					&dummy,				/* mouse button      */
					&dummy,				/* shift keys        */
					&key,				/* key pressed       */
					&dummy);				/* no. of clicks     */
		wind_update(BEG_UPDATE);
		if(event_type & MU_MESAG)
		{
			if(mgbuf[0] == MN_SELECTED)
				hndl_menu(mgbuf[3],mgbuf[4]);
		}
		else if(event_type & MU_KEYBD)
		{
			switch(key)
			{
				case F1_KEY:	hndl_menu(FILEMENU,CONVFILE);
								break;
				case F10_KEY:	hndl_menu(FILEMENU,TODESK);
								break;
			}	
		}
		wind_update(END_UPDATE);
	}
	menu_bar(menuaddr,NO);							/* turn off menu bar */
	v_clsvwk(handle);
	appl_exit();
}

/* getpath() gets the current path after the program is loaded */
getpath()
{
	char buffer[120];					/* used in the pathname construction */
	name[0] = '\0';
	Dgetpath(buffer,0);								/* get current pathname */
	sprintf(drv,"%c",drive = Dgetdrv() + 'A');
	strcpy(dirset,drv);								/* add drive letter */
	strcat(dirset,":");
	strcat(dirset,buffer);							/* add path to drive */
	strcat(dirset,"\\*.TGA");						/* add \*.TGA */
	strcpy(dirpath,dirset);							/* construct the pathname */
}

/*************************************************************************
fix_path() removes all characters after the last backslash in the
directory path.  This is used to remove the *.* or other string that the
file selector uses to get a directory
the file name chosen in the file selector is then added to the path to
make the complete path string
**************************************************************************/
fix_path()
{
	strcpy(pathname,dirpath);         /* leave dirpath unchanged */
	for (i=strlen(pathname); ((i > 0) && pathname[i] != '\\'); i--)
		;
	pathname[i+1] = '\0';
	strcat(pathname, filename[filenum]);
}

fix_savepath()
{
	strcpy(savepathname,savepath);         /* leave savepath unchanged */
	for (i=strlen(savepathname); ((i > 0) && savepathname[i] != '\\'); i--)
		;
	savepathname[i+1] = '\0';
	strcat(savepathname, name);
}

/***************************************************************************
add_extension() removes the extension from the filename of the TGA file
that was loaded.  Then an extension is added to get the new default filename
that appears when you choose the file to save
***************************************************************************/
add_extension()
{
	strcpy(savepath,dirpath);
	for (i=strlen(savepath); ((i > 0) && savepath[i] != '\\'); i--)
		;
	savepath[i+1] = '\0';
	if(data_type == CRY16)
		strcat(savepath, "*.CRY");
	else
		strcat(savepath, "*.RGB");
	strcpy(name,filename[0]);
	for (i=strlen(name); i >= 0; i--)
		if(i == 0 || name[i] == '.')
		{
			if(name[i] == '.')
				name[i+1] = '\0';
			else
				strcat(name, ".");
			if(data_type == CRY16)
				strcat(name, "CRY");
			else
				strcat(name, "RGB");
			break;
		}
}

/************************************************************************/
/* get the file name of the image, remove the extension if any, and		*/
/* change the upper case letters to lower case letters					*/
/* this name will be used as the label for the image data				*/
/************************************************************************/
get_name_without_ext()
{
	strcpy(picname,filename[filenum]);
	for (i=strlen(picname); i >= 0; i--)
		if(picname[i] == '.')
			picname[i] = '\0';
		else if(picname[i] >= 'A' && picname[i] <= 'Z')
			picname[i] += 32;				/* change 'A'-'Z' to 'a'-'z' */
}


filelist()
{
	int stop = NO;
	DMABUFFER tempbuf;
	Fsetdta(&tempbuf);
	strcpy(dirpath, dirset);
	filecount = 0;
	strcpy(name,"*.TGA");					/* default filename is *.TGA */
	if (fsel_exinput(dirpath, name, &button, "LOAD TGA FILE") == 0)
		return(0);
	else if ((button == 1) && (name[0] != '\0'))	/* selected a file */
	{
		strcpy(pathname,dirpath);
		for (i=strlen(pathname); ((i > 0) && pathname[i] != '\\'); i--)
			;
		pathname[i+1] = '\0';
		strcat(pathname, name);
		if(Fsfirst(pathname, 0) == 0)
		{
			filesize[filecount] = tempbuf.d_fsize;
			strcpy(filename[filecount++], tempbuf.d_fname);
			while(stop == NO)
			{
				if(Fsnext() == 0)			/* file was found */
				{
					filesize[filecount] = tempbuf.d_fsize;
					strcpy(filename[filecount++],tempbuf.d_fname);
				}
				else
					stop = YES;
			}
			add_extension();
			if(fsel_exinput(savepath, name, &button, "SAVE NEW DATA") == 0)
				return(0);
			else if ((button == 1) && (name[0] != '\0'))
			{
				fix_savepath();
				(int)nhandle = Fcreate(savepathname, 0x00);
			}
		}
		else
		{
			stop = YES;
			form_alert(1, filenotfound);		/* no files found */
			return(0);
		}
	}
}


/****************************************************************************/
/* make_new_file() writes the data in the srcfile buffer into a new file	*/
/****************************************************************************/
make_new_file()
{
	draw_current_filenum();
	fix_path();
	srcfile = (char *)Malloc(filesize[filenum]);
	if(srcfile != NULL)
	{
		BEE_MOUSE;
		fhandle = (int)Fopen(pathname,2);
		Fread(fhandle, filesize[filenum], srcfile);
		Fclose (fhandle);
	}
	else
	{
		form_alert(1, outofmemory);
		return(0);
	}
	read_header();
	if(bits_per_pixel != 24)
	{
		form_alert(1, wrongformat);
		return(0);
	}
	else
		make_newdata();
	Mfree(srcfile);
}

read_header()
{
	int *temp;
	temp = &srcfile[0L];
	(int)bytes_in_name = *temp;
	bytes_in_name = bytes_in_name / 256;
	temp = &srcfile[12L];
	(int)image_w = *temp;
	image_w = ((image_w/256) + ((image_w & 0xFF) * 256));	/* swap bytes */
	temp = &srcfile[14L];
	(int)image_h = *temp;
	image_h = ((image_h/256) + ((image_h & 0xFF) * 256));	/* swap bytes */
	temp = &srcfile[16L];
	(int)bits_per_pixel = *temp;
	bits_per_pixel = bits_per_pixel / 256;
}

make_newdata()
{
	items_per_line = 0;				/* count words per line in new file */
	
	newdata = srcfile + 18 + bytes_in_name;		/* skip the header bytes */

	get_name_without_ext();					/* get name of image */
	sprintf(ts,"%s::\n",picname);
	Fwrite(nhandle, (long)strlen(ts), ts);
	sprintf(ts,";%d x %d\n",image_w,image_h);
	Fwrite(nhandle, (long)strlen(ts), ts);

	completed = 0;

	switch(hflip_flag)
	{
		case YES:	if(vflip_flag == YES)
						make_hflip_vflip_data();
					else
						make_hflip_data();
					break;
		case NO:	if(vflip_flag == YES)
						make_vflip_data();
					else
						make_normal_data();
					break;
	}
	Fwrite(nhandle, 1L, "\n");			/* end of data */
}

make_normal_data()
/* no hflip or vflip */
{
	for(line = (image_h-1); line >= 0; line--)
	{
		for(column = 0; column < (image_w *3); column += 3)
		{
			blue = newdata[line * (long)(image_w * 3) + column];
			green = newdata[line * (long)(image_w * 3) + column + 1];
			red = newdata[line * (long)(image_w * 3) + column + 2];
			convert_rgb_pixel();
		}
		completed = (image_h - line) * 100 / image_h;
		draw_percentage();
	}
}

make_hflip_data()
/* hflip, no vflip */
{
	for(line = (image_h-1); line >= 0; line--)
	{
		for(column = ((image_w * 3)-1); (column+1) > 0; column -= 3)
		{
			blue = newdata[line * (long)(image_w * 3) + column - 2];
			green = newdata[line * (long)(image_w * 3) + column - 1];
			red = newdata[line * (long)(image_w * 3) + column];
			convert_rgb_pixel();
		}
		completed = (image_h - line) * 100 / image_h;
		draw_percentage();
	}
}

make_vflip_data()
/* vflip, no hflip */
{
	for(line = 0; line < image_h; line++)
	{
		for(column = 0; column < (image_w *3); column += 3)
		{
			blue = newdata[line * (long)(image_w * 3) + column];
			green = newdata[line * (long)(image_w * 3) + column + 1];
			red = newdata[line * (long)(image_w * 3) + column + 2];
			convert_rgb_pixel();
		}
		completed = (line + 1) * 100 / image_h;
		draw_percentage();
	}
}

make_hflip_vflip_data()
/* hflip and vflip */
{
	for(line = 0; line < image_h; line++)
	{
		for(column = ((image_w * 3)-1); (column+1) > 0; column -= 3)
		{
			blue = newdata[line * (long)(image_w * 3) + column - 2];
			green = newdata[line * (long)(image_w * 3) + column - 1];
			red = newdata[line * (long)(image_w * 3) + column];
			convert_rgb_pixel();
		}
		completed = (line + 1) * 100 / image_h;
		draw_percentage();
	}
}

convert_rgb_pixel()
/* used by make_normal, make_hflip, make_vflip, make_hflip_vflip */
{
	switch(data_type)
	{
		case CRY16:	if(items_per_line == 0)
						Fwrite(nhandle, 6L, "\tdc.w\t");		/* start new line */
					do_cry();
					break;
		case RGB16:	if(items_per_line == 0)
						Fwrite(nhandle, 6L, "\tdc.w\t");		/* start new line */
					do_rgb16();
					break;
		case RGB24:	if(items_per_line == 0)
						Fwrite(nhandle, 6L, "\tdc.l\t");		/* start new line */
					do_rgb24();
					break;
	}
}

do_cry()
{
	intensity = red;				/* start with red */
	if(green > intensity)
		intensity = green;
	if(blue > intensity)
		intensity = blue;			/* get highest RGB value */
	if(intensity != 0)
	{
		red = (unsigned int)red * 255 / intensity;
		green = (unsigned int)green * 255 / intensity;
		blue = (unsigned int)blue * 255 / intensity;
	}
	else
		red = green = blue = 0;		/* R, G, B, were all 0 (black) */

	color_offset = (red & 0xF8) << 7;
	color_offset += (green & 0xF8) << 2;
	color_offset += (blue & 0xF8) >> 3;		/* now we have offset for cry table */

	if(items_per_line == 0)
		sprintf(ts,"$%02x%02x",cry[color_offset],intensity);
	else
		sprintf(ts,",$%02x%02x",cry[color_offset],intensity);
	Fwrite(nhandle, (long)strlen(ts), ts);
	if(items_per_line++ == 15)				/* print 16 words per line */
	{
		Fwrite(nhandle, 1L, "\n");		/* end line */
		items_per_line = 0;
	}
}

do_rgb16()
{
	int temp0;
	temp0 = (red >> 3) << 5;					/* reduce red to 5 bits, shift left 5 bits */
	temp0 += blue >> 3;						/* reduce blue to 5 bits */
	temp0 = temp0 << 6;						/* make room for green */
	temp0 += green >> 2;					/* reduce green to 6 bits */

	if(items_per_line == 0)
		sprintf(ts,"$%04x",temp0);
	else
		sprintf(ts,",$%04x",temp0);
	Fwrite(nhandle, (long)strlen(ts), ts);
	if(items_per_line++ == 15)				/* print 16 words per line */
	{
		Fwrite(nhandle, 1L, "\n");			/* end line */
		items_per_line = 0;
	}
}

do_rgb24()
{
	if(items_per_line == 0)
		sprintf(ts,"$%02x%02x00%02x",green,red,blue);	/* green,red,unused,blue */
	else
		sprintf(ts,",$%02x%02x00%02x",green,red,blue);
	Fwrite(nhandle, (long)strlen(ts), ts);
	if(items_per_line++ == 7)				/* print 8 longs per line */
	{
		Fwrite(nhandle, 1L, "\n");			/* end line */
		items_per_line = 0;
	}
}

do_about_box()
{
	rsrc_gaddr(R_TREE, ABOUTBOX, &daddr);
	form_center(daddr, &xdial, &ydial, &wdial, &hdial);
	form_dial(FMD_START, 0, 0, 0, 0, xdial, ydial, wdial, hdial);
	form_dial(FMD_GROW, 0, 0, 0, 0, xdial, ydial, wdial, hdial);
	objc_draw(daddr, ROOT, MAX_DEPTH, xdial, ydial, wdial, hdial);
	exitobj = form_do(daddr,0) & 0x7FFF;
	objc_change(daddr,exitobj,0,DESKSIZE,NORMAL,0);
	form_dial(FMD_SHRINK, 0, 0, 0, 0, xdial, ydial, wdial, hdial);
	form_dial(FMD_FINISH, 0, 0, 0, 0, xdial, ydial, wdial, hdial);
}

open_percent_box()
{
	form_center(paddr, &pxdial, &pydial, &pwdial, &phdial);
	form_dial(FMD_START, 0, 0, 0, 0, pxdial, pydial, pwdial, phdial);
	form_dial(FMD_GROW, 0, 0, 0, 0, pxdial, pydial, pwdial, phdial);
	objc_draw(paddr, ROOT, MAX_DEPTH, pxdial, pydial, pwdial, phdial);
}

draw_percentage()
{
	sprintf(((TEDINFO *)paddr[PERCNTGE].ob_spec)->te_ptext,"%3ld", completed);
	objc_draw(paddr, PERCNTGE, MAX_DEPTH, pxdial, pydial, pwdial, phdial);
}

draw_current_filenum()
{
	sprintf(((TEDINFO *)paddr[CURFILE].ob_spec)->te_ptext,"%2d", filenum+1);
	objc_draw(paddr, CURFILE, MAX_DEPTH, pxdial, pydial, pwdial, phdial);
}

hndl_menu(title,item)
int title;							/* title is menu from menu bar */
int item;								/* item is choice in the menu */
{
	switch (title)
	{
		case DESKMENU:	do_about_box();
						break;
		case FILEMENU:	switch(item)
					{
						case CONVFILE:	filelist();
									if(filecount > 0)
									{
										completed = 0L;
										sprintf(((TEDINFO *)paddr[PERCNTGE].ob_spec)->te_ptext,"%3ld", completed);
										sprintf(((TEDINFO *)paddr[CURFILE].ob_spec)->te_ptext," 1");
										sprintf(((TEDINFO *)paddr[TOTFILES].ob_spec)->te_ptext,"%2d", filecount);
										open_percent_box();
										for(filenum=0; filenum < filecount; filenum++)
											make_new_file();
										filecount = 0;
									}
									Fclose(nhandle);
									form_dial(FMD_SHRINK,0,0,0,0,pxdial,pydial,pwdial,phdial);	/* percent box */
									form_dial(FMD_FINISH,0,0,0,0,pxdial,pydial,pwdial,phdial);
									ARROW_MOUSE;
									SHOW_MOUSE;
									break;
						case TODESK:	quit = YES;
									break;
					}
		case OPTMENU:	switch(item)
					{
						case CRYDATA:	data_type = CRY16;
									menu_icheck(menuaddr,CRYDATA,YES);
									menu_icheck(menuaddr,RGBDATA,NO);
									menu_icheck(menuaddr,RGB24DAT,NO);
									break;
						case RGBDATA:	data_type = RGB16;
									menu_icheck(menuaddr,CRYDATA,NO);
									menu_icheck(menuaddr,RGBDATA,YES);
									menu_icheck(menuaddr,RGB24DAT,NO);
									break;
						case RGB24DAT:	data_type = RGB24;
									menu_icheck(menuaddr,CRYDATA,NO);
									menu_icheck(menuaddr,RGBDATA,NO);
									menu_icheck(menuaddr,RGB24DAT,YES);
									break;
						case HORFLIP:	hflip_flag = 1 - hflip_flag;
									menu_icheck(menuaddr,HORFLIP,hflip_flag);
									break;
						case VERTFLIP:	vflip_flag = 1 - vflip_flag;
									menu_icheck(menuaddr,VERTFLIP,vflip_flag);
									break;
					}
					break;
	}
	menu_tnormal(menuaddr,title,YES);			/* return menu item to normal */
}


